package net.w_horse.excelpojo.excel.cellseeker;

import java.lang.annotation.Annotation;

import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;

import org.apache.poi.ss.usermodel.Sheet;

public class VerticalRepeatsSeeker extends AbstractRepeatsSeeker {

	@Override
	public void set(Annotation annotation, ExcelPOJOAnnotationParser parser) throws ClassNotFoundException, LinkageError, ExcelPOJOException {
		parser.setCellSeeker(annotation, this);
	}

	@Override
	int getRowLimit(Sheet sheet) {
		return sheet.getLastRowNum();
	}

	@Override
	Offset getOffset(int rowIndex) {
		return new Offset(rowIndex, 0);
	}

	@Override
	Offset getOffset4MappedCell(int rowIndex) {
		return new Offset(rowIndex -1, 1);
	}

	@Override
	protected Offset getRangeOffset() {
		return new Offset(0, -1);
	}

}
